# -*- coding: utf-8 -*-

#DRIVEN_JOINTS.PY
#@author: Thomas Gillis
#
#Created on 1/7/2013
#Last update on 3/7/2013
#
#Copyright 2013 Universite Catholique de Louvain


import numpy as np
import MBsysPy
import math

def user_DrivenJoints(mbs_data,tsim):
    """ Set the values of the driven joints directly in the mbs structure

    :param mbs: The Data structure
    :param tsim: the simulation time
    
    """
#==============================================================================
# BEGIN OF USER CODE
#==============================================================================
#    print("user_DrivenJoints - Python - Mercedes")
#    tsim+=1
#    print("provided tsim:"+str(tsim)+"[s]'.")
#    print("MbsData  tsim:"+str(mbs_data.tsim)+"[s]'.")
    
    if mbs_data.process == 50:
        rod2_id     = mbs_data.joint_id["R1_chassis_barre2"]
        rod2_R1_min = -1.1
        rod2_R1_max =  1.2
        rod2_R1_0   =  mbs_data.q0[rod2_id]
        
        mbs_data.q[rod2_id]   = (rod2_R1_min - rod2_R1_0)*tsim +  rod2_R1_0
        mbs_data.qd[rod2_id]  = 0.0
        mbs_data.qdd[rod2_id] = 0.0
    
    elif mbs_data.process == 51:
        rod2_id     = mbs_data.joint_id["R1_chassis_barre2"]
        rod2_R1_min = -1.1
        rod2_R1_max =  1.2
        rod2_R1_0   = mbs_data.q0[rod2_id]
        
        mbs_data.q[rod2_id]   = (rod2_R1_max - rod2_R1_min)*tsim +  rod2_R1_min
        mbs_data.qd[rod2_id]  = 0.0
        mbs_data.qdd[rod2_id] = 0.0   
        
        
    elif mbs_data.process == 30:
        Poster_id = mbs_data.joint_id['T3_poster']
        Z = -0.1
               
        if tsim < 0.2:
            mbs_data.q[Poster_id]   = 0.0
            mbs_data.qd[Poster_id]  = 0.0
            mbs_data.qdd[Poster_id] = 0.0  
            
        else:                    
            mbs_data.q[Poster_id]   = Z
            mbs_data.qd[Poster_id]  = 0.0
            mbs_data.qdd[Poster_id] = 0.0               

    elif mbs_data.process == 31:  
        Poster_id = mbs_data.joint_id['T3_poster']
        zmax = 0.005
        f0 = 1.
        t0 = 0.
        f1 = 10.
        t1 = 10.

        # Contact forces between wheel-ground are only spring law (no damping) 
        # We only implement the trajectory because forces only depend on the position
        mbs_data.q[Poster_id]   = zmax*np.sin(2*np.pi*(f0+(f1-f0)/(t1-t0)*tsim/2.0)*tsim)
        mbs_data.qd[Poster_id]  = 0
        mbs_data.qdd[Poster_id] = 0
        
#==============================================================================
# END OF USER CODE
#==============================================================================
    return
